/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.internal.core.launching;

import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.GitExecutable;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.core.model.IGitRepositoryManager;
import com.aptana.git.internal.core.launching.Messages;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitLaunchDelegate
extends LaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ArrayList<? extends String> commandList = new ArrayList<String>();
        IPath gitExecutablePath = this.gitExecutable(configuration);
        commandList.add(gitExecutablePath.toOSString());
        commandList.addAll(this.arguments(configuration));
        IPath workingDir = this.getWorkingDirectory(configuration);
        String[] env = this.getEnvironment(configuration);
        Process process = DebugPlugin.exec((String[])commandList.toArray(new String[commandList.size()]), (File)(workingDir == null ? null : workingDir.toFile()), (String[])env);
        String label = (String)commandList.get(0);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(IProcess.ATTR_PROCESS_TYPE, "git");
        DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)label, map);
    }

    private Collection<? extends String> arguments(ILaunchConfiguration configuration) throws CoreException {
        String interpreterArgs = configuration.getAttribute("ATTR_ARGUMENTS", null);
        return Arrays.asList(DebugPlugin.parseArguments((String)interpreterArgs));
    }

    private String[] getEnvironment(ILaunchConfiguration configuration) throws CoreException {
        return DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
    }

    protected IPath getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        String workingDirVal = configuration.getAttribute("ATTR_WORKING_DIRECTORY", null);
        if (workingDirVal == null) {
            return null;
        }
        IPath workingDirectory = Path.fromOSString((String)workingDirVal);
        if (!workingDirectory.toFile().isDirectory()) {
            this.abort(MessageFormat.format(Messages.GitLaunchDelegate_InvalidWorkingDir, workingDirVal), null);
        }
        return workingDirectory;
    }

    protected IPath gitExecutable(ILaunchConfiguration configuration) throws CoreException {
        IPath path = null;
        String location = configuration.getAttribute("ATTR_LOCATION", null);
        if (location != null) {
            path = Path.fromOSString((String)location);
        }
        if (path == null) {
            GitExecutable executable = GitExecutable.instance();
            path = executable.path();
        }
        if (path == null) {
            this.abort(Messages.GitLaunchDelegate_NoGitExecutableSpecified, null);
        }
        if (!path.toFile().exists()) {
            this.abort(MessageFormat.format(Messages.GitLaunchDelegate_GitExecutableDoesntExist, path), null);
        }
        return path;
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        IPath wd = this.getWorkingDirectory(configuration);
        if (wd != null) {
            GitRepository repo = this.getRepositoryManager().getUnattachedExisting(wd.toFile().toURI());
            HashSet<IProject> affectedProjects = new HashSet<IProject>();
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                GitRepository other = this.getRepositoryManager().getAttached(project);
                if (other != null && other.equals(repo)) {
                    affectedProjects.add(project);
                }
                ++n2;
            }
            return this.computeBuildOrder(affectedProjects.toArray(new IProject[affectedProjects.size()]));
        }
        return super.getBuildOrder(configuration, mode);
    }

    protected IGitRepositoryManager getRepositoryManager() {
        return GitPlugin.getDefault().getGitRepositoryManager();
    }

    private void abort(String message, Throwable e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "com.aptana.git.core", 0, message, e));
    }
}

